unit UOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  DB, ADODB, Dialogs,
  { }
  UTabela, URekord;

type

MOsoby = class(MTabela)
public
   Rek : MOsobaRec;

   function    DajWszystko() : Boolean; override;
	function    Edit(rec : MRekord) : Boolean; override;
	function    Insert(rec : MRekord) : Boolean; override;
   function    Delete(id : Integer) : Boolean; override;

	procedure   GetRec(); override;

	function    DajWybraneNazwiska(parNazwisko : String) : Boolean;


	constructor Create(); override;
   destructor  Destroy(); override;
end;


implementation
{------------------------------------------------------------------------------}
constructor MOsoby.Create();
begin
	inherited;
   
   Rek := MOsobaRec.Create();
end;

destructor MOsoby.Destroy();
begin
	if Assigned(Rek) then
   begin
		FreeAndNil(Rek);
   end;
end;

function MOsoby.DajWszystko() : Boolean;
var
	ret : Boolean;

begin
   ret := false;

   sql_txt  := 'select * from OSOBY order by nazwisko, imie';

   LQ.SQL.Clear();
   LQ.SQL.Add(sql_txt);

   ret  := Open();

   Result := ret;
end;

procedure MOsoby.GetRec();
begin
   Rek.idosoby  := LQ.FieldByName('idosoby').AsInteger;
   Rek.nazwisko := LQ.FieldByName('nazwisko').AsString;
   Rek.imie     := LQ.FieldByName('imie').AsString;
   Rek.dataur   := LQ.FieldByName('dataur').AsDateTime;
   Rek.mcowosc  := LQ.FieldByName('mcowosc').AsString;
   Rek.ulicainr := LQ.FieldByName('ulicainr').AsString;
   Rek.kodp     := LQ.FieldByName('kodp').AsString;
   Rek.miasto   := LQ.FieldByName('miasto').AsString;
   Rek.pesel    := LQ.FieldByName('pesel').AsString;
end;

function MOsoby.Insert(rec : MRekord) : Boolean;
var
	ret : Boolean;

begin
   ret := true;

   sql_txt := '';
   sql_txt := sql_txt + 'insert into OSOBY( ';
   sql_txt := sql_txt + 'nazwisko, ';
   sql_txt := sql_txt + 'imie, ';
   sql_txt := sql_txt + 'dataur, ';
   sql_txt := sql_txt + 'mcowosc, ';
   sql_txt := sql_txt + 'ulicainr, ';
   sql_txt := sql_txt + 'kodp, ';
   sql_txt := sql_txt + 'miasto, ';
   sql_txt := sql_txt + 'pesel )';
   sql_txt := sql_txt + 'VALUES( ';
   sql_txt := sql_txt + ':nazwisko, ';
   sql_txt := sql_txt + ':imie, ';
   sql_txt := sql_txt + ':dataur, ';
   sql_txt := sql_txt + ':mcowosc, ';
   sql_txt := sql_txt + ':ulicainr, ';
   sql_txt := sql_txt + ':kodp, ';
   sql_txt := sql_txt + ':miasto, ';
   sql_txt := sql_txt + ':pesel )';

   LQ.SQL.Clear();
   LQ.SQL.Add(sql_txt);

   // bez pierwszego pola
   LQ.Parameters.ParamByName('nazwisko').Value := MOsobaRec(rec).nazwisko;
   LQ.Parameters.ParamByName('imie').Value     := MOsobaRec(rec).imie;
   LQ.Parameters.ParamByName('dataur').Value   := MOsobaRec(rec).dataur;
   LQ.Parameters.ParamByName('mcowosc').Value  := MOsobaRec(rec).mcowosc;
   LQ.Parameters.ParamByName('ulicainr').Value := MOsobaRec(rec).ulicainr;
   LQ.Parameters.ParamByName('kodp').Value     := MOsobaRec(rec).kodp;
   LQ.Parameters.ParamByName('miasto').Value   := MOsobaRec(rec).miasto;
   LQ.Parameters.ParamByName('pesel').Value    := MOsobaRec(rec).pesel;

   ret := ExecSQL(true);

   Result := ret;
end;

function MOsoby.Edit(rec : MRekord) : Boolean;
var
	ret : Boolean;

begin
   ret := true;

   sql_txt := '';
   sql_txt := sql_txt + 'update OSOBY SET ';
   sql_txt := sql_txt + 'nazwisko      = :nazwisko, ';
   sql_txt := sql_txt + 'imie          = :imie, ';
   sql_txt := sql_txt + 'dataur        = :dataur, ';
   sql_txt := sql_txt + 'mcowosc       = :mcowosc, ';
   sql_txt := sql_txt + 'ulicainr      = :ulicainr, ';
   sql_txt := sql_txt + 'kodp          = :kodp, ';
   sql_txt := sql_txt + 'miasto        = :miasto, ';
   sql_txt := sql_txt + 'pesel         = :pesel ';
   sql_txt := sql_txt + 'where idosoby = :idosoby';

   LQ.SQL.Clear();
   LQ.SQL.Add(sql_txt);

   LQ.Parameters.ParamByName('idosoby').Value  := MOsobaRec(rec).idosoby;
   LQ.Parameters.ParamByName('nazwisko').Value := MOsobaRec(rec).nazwisko;
   LQ.Parameters.ParamByName('imie').Value     := MOsobaRec(rec).imie;
   LQ.Parameters.ParamByName('dataur').Value   := MOsobaRec(rec).dataur;
   LQ.Parameters.ParamByName('mcowosc').Value  := MOsobaRec(rec).mcowosc;
   LQ.Parameters.ParamByName('ulicainr').Value := MOsobaRec(rec).ulicainr;
   LQ.Parameters.ParamByName('kodp').Value     := MOsobaRec(rec).kodp;
   LQ.Parameters.ParamByName('miasto').Value   := MOsobaRec(rec).miasto;
   LQ.Parameters.ParamByName('pesel').Value    := MOsobaRec(rec).pesel;

   ret := ExecSQL(true);

   Result := ret;
end;

function MOsoby.Delete(id : Integer) : Boolean;
var
	ret : Boolean;

begin
   ret := true;

   sql_txt := sql_txt + 'delete from OSOBY where IdOsoby = :IDOSOBY ';

   LQ.SQL.Clear();
   LQ.SQL.Add(sql_txt);

   LQ.Parameters.ParamByName('IDOSOBY').Value := Id;

   ret := ExecSQL(true);

   Result := ret;
end;

function MOsoby.DajWybraneNazwiska(parNazwisko : String) : Boolean;
var
   nazwisko        : String;
	wynik_zapytania : Boolean;

begin
	nazwisko := parNazwisko;
   nazwisko := nazwisko + '%';

   wynik_zapytania := true;

   sql_txt := '';
   sql_txt := sql_txt + 'select * from OSOBY where nazwisko like :NAZWISKO ';
   sql_txt := sql_txt + 'order by nazwisko, imie';

   LQ.SQL.Clear();
   LQ.SQL.Add(sql_txt);

   LQ.Parameters.ParamByName('NAZWISKO').Value := nazwisko;
   
   wynik_zapytania := Open();
   
   Result := wynik_zapytania;
end;

end.

